<?php

namespace Snapfile\Entities\Billing;

use Illuminate\Database\Eloquent\Model;

class BillingDetails extends Model 
{

    protected $table = 'billing_details';
    public $timestamps = true;
    protected $fillable = array('user_id', 'business_profile_id', 'payment_type', 'billing_options');
    protected $visible = array('user_id', 'business_profile_id', 'payment_type', 'billing_options');

    public function user()
    {
        return $this->belongsTo('Snapfile\Entities\User\User', 'user_id');
    }

    public function businessProfile()
    {
        return $this->belongsTo('Snapfile\Entities\Business\BusinessProfile', 'business_profile_id');
    }

    public function subscriptions()
    {
        return $this->hasMany('Snapfile\Entities\Billing\Subscription', 'billing_details_id');
    }

    public function billHistory()
    {
        return $this->hasMany('Snapfile\Entities\Billing\Bill', 'billing_details_id');
    }

}